/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	FoodStore
**
** DESCRIPTION:	Maintains the food store
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef FOODSTORE_H
#define FOODSTORE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int FoodStore_c_iInitialLevel = 60;
const int FoodStore_c_iLowLevel	= 250;
const int FoodStore_c_iOKLevel = 1000;
const int FoodStore_c_iAbundantLevel = 8000;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CFoodStore
{
public:

	//class structures
	struct SSaveState
	{
		int		m_iFood;
	};

private:

	//class data
	int			m_iFood;

	//class methods
	//setup
	public:		CFoodStore(void);
	public:		void Reset();
	public:		const bool LoadState(const SSaveState &sSaveState);
	public:		const bool SaveState(SSaveState &sSaveState) const;

	// process

	// access
	public:		void Adjust(const int iAdj);
	public:		const int Level() const { return m_iFood; }
	public:		const bool IsLow() const { return m_iFood <= FoodStore_c_iLowLevel; }
	public:		const bool IsOK() const { return m_iFood >= FoodStore_c_iOKLevel; }
	public:		const bool IsAbundant() const { return m_iFood >= FoodStore_c_iAbundantLevel; }
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CFoodStore		FoodStore;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/